﻿
<?php $__env->startSection('title','Mutasi Karyawan'); ?>
<?php $__env->startSection('page-title','Mutasi Karyawan'); ?>
<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
<div class="alert alert-success alert-dismissible fade show py-2" role="alert">
    <i class="bi bi-check-circle me-1"></i> <?php echo session('success'); ?>

    <button type="button" class="btn-close py-2" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>


<form method="POST" action="<?php echo e(route('admin.mutasi.bulk-assign')); ?>" id="bulkForm">
<?php echo csrf_field(); ?>


<div class="card mb-3">
    <div class="card-body py-2 px-3">
        <div class="d-flex align-items-center gap-2 flex-wrap">
            <span class="fw-semibold me-1" style="font-size:.85rem;">
                <i class="bi bi-people me-1"></i>
                <span id="selectedCount">0</span> karyawan dipilih
            </span>
            <div class="vr mx-1"></div>
            <label class="fw-semibold mb-0" style="font-size:.85rem; white-space:nowrap;">
                Pindahkan ke Tahun:
            </label>
            <select name="tahun_penilaian_id" class="form-select form-select-sm" style="width:auto; min-width:160px;" required>
                <option value=""> Pilih Tahun </option>
                <?php $__currentLoopData = $tahunList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($t->id); ?>">
                    <?php echo e($t->periode_penilaian); ?><?php echo e($t->is_active ? ' (Aktif)' : ''); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="btn btn-primary btn-sm" id="btnBulk" disabled>
                <i class="bi bi-arrow-left-right me-1"></i>Terapkan
            </button>
            <button type="button" class="btn btn-outline-secondary btn-sm ms-1" id="btnClear">
                <i class="bi bi-x-lg me-1"></i>Batal Pilih
            </button>
        </div>
    </div>
</div>


<div class="card">
    <div class="card-header py-2">
        <span class="fw-semibold"><i class="bi bi-arrow-left-right me-2"></i>Mutasi Karyawan  Penentuan Tahun Ajaran</span>
        <span class="badge bg-primary ms-2"><?php echo e($karyawan->total()); ?> Karyawan</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0 align-middle">
                <thead class="table-light">
                    <tr>
                        <th width="40" class="text-center">
                            <input class="form-check-input" type="checkbox" id="checkAll" title="Pilih Semua">
                        </th>
                        <th>Kode Karyawan</th>
                        <th>Nama Karyawan</th>
                        <th>Alamat</th>
                        <th>Tahun Ajaran Saat Ini</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $karyawan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="row-item">
                        <td class="text-center">
                            <input class="form-check-input row-check" type="checkbox"
                                   name="karyawan_ids[]" value="<?php echo e($k->id); ?>">
                        </td>
                        <td><span class="badge bg-secondary"><?php echo e($k->kode_karyawan); ?></span></td>
                        <td class="fw-semibold"><?php echo e($k->nama_karyawan); ?></td>
                        <td class="text-truncate" style="max-width:220px;"><?php echo e($k->alamat ?? '-'); ?></td>
                        <td>
                            <?php if($k->tahunPenilaian): ?>
                                <?php echo e($k->tahunPenilaian->periode_penilaian); ?>

                                <?php if($k->tahunPenilaian->is_active): ?>
                                    <span class="badge bg-success ms-1" style="font-size:.65rem;">Aktif</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center text-muted py-4">Belum ada data karyawan.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($karyawan->hasPages()): ?>
    <div class="card-footer"><?php echo e($karyawan->links()); ?></div>
    <?php endif; ?>
</div>

</form>

<script>
const checkAll  = document.getElementById('checkAll');
const btnBulk   = document.getElementById('btnBulk');
const btnClear  = document.getElementById('btnClear');
const counter   = document.getElementById('selectedCount');

function updateState() {
    const checks = document.querySelectorAll('.row-check');
    const checked = document.querySelectorAll('.row-check:checked');
    counter.textContent = checked.length;
    btnBulk.disabled = checked.length === 0;
    checkAll.indeterminate = checked.length > 0 && checked.length < checks.length;
    checkAll.checked = checks.length > 0 && checked.length === checks.length;
    document.querySelectorAll('.row-item').forEach(tr => {
        tr.classList.toggle('table-active', tr.querySelector('.row-check').checked);
    });
}

checkAll.addEventListener('change', () => {
    document.querySelectorAll('.row-check').forEach(cb => cb.checked = checkAll.checked);
    updateState();
});

document.querySelectorAll('.row-check').forEach(cb => cb.addEventListener('change', updateState));

btnClear.addEventListener('click', () => {
    document.querySelectorAll('.row-check').forEach(cb => cb.checked = false);
    checkAll.checked = false;
    updateState();
});

document.getElementById('bulkForm').addEventListener('submit', function(e) {
    const checked = document.querySelectorAll('.row-check:checked');
    if (checked.length === 0) { e.preventDefault(); alert('Pilih minimal 1 karyawan.'); }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Project\Blanko Penilaian Pengabdian\penilaian-pengabdian\resources\views/admin/mutasi/index.blade.php ENDPATH**/ ?>