﻿
<?php $__env->startSection('title','Transaksi Penilaian'); ?>
<?php $__env->startSection('page-title','Transaksi Penilaian'); ?>
<?php $__env->startSection('content'); ?>

<?php if(session('success')): ?>
<div class="alert alert-success alert-dismissible fade show py-2" role="alert">
    <i class="bi bi-check-circle me-1"></i> <?php echo e(session('success')); ?>

    <button type="button" class="btn-close py-2" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>


<form method="GET" action="<?php echo e(route('admin.transaksi.index')); ?>" class="mb-3 d-flex align-items-center gap-2">
    <label class="fw-semibold me-1" style="font-size:.85rem; white-space:nowrap;"><i class="bi bi-funnel me-1"></i>Tahun Ajaran:</label>
    <select name="tahun_penilaian_id" class="form-select form-select-sm" style="max-width:200px;" onchange="this.form.submit()">
        <option value="">-- Semua Tahun --</option>
        <?php $__currentLoopData = $tahunList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($t->id); ?>" <?php echo e($selectedTahun == $t->id ? 'selected' : ''); ?>>
            <?php echo e($t->periode_penilaian); ?> <?php echo e($t->is_active ? '(Aktif)' : ''); ?>

        </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php if($selectedTahun): ?>
        <a href="<?php echo e(route('admin.transaksi.index')); ?>" class="btn btn-sm btn-outline-secondary">Reset</a>
    <?php endif; ?>
</form>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center py-2">
        <span class="fw-semibold"><i class="bi bi-receipt me-2"></i>Input & Rekap Penilaian</span>
        <a href="<?php echo e(route('admin.transaksi.create', $selectedTahun ? ['tahun_penilaian_id' => $selectedTahun] : [])); ?>"
           class="btn btn-primary btn-sm">
            <i class="bi bi-pencil-square me-1"></i>Input Nilai
        </a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0 align-middle" style="font-size:.84rem;">
                <thead class="table-light">
                    <tr>
                        <th width="36">No</th>
                        <th>Karyawan</th>
                        <th>Pangkalan Job</th>
                        <th width="80" class="text-center">Terisi</th>
                        <th width="90" class="text-center">Nilai Akhir</th>
                        <th width="120" class="text-center">Rating</th>
                        <th width="100">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $karyawanList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $trx      = $k->transaksi;
                        $terisi   = $trx->count();
                        $progress = $totalKompetensi > 0 ? round($terisi / $totalKompetensi * 100) : 0;

                        // Weighted score: for each kategori, avg(nilai) Ã— bobot; sum / totalBobot
                        $nilaiAkhir = null;
                        if ($terisi > 0) {
                            $grouped = $trx->filter(fn($t) => $t->nilai !== null)
                                          ->groupBy(fn($t) => $t->kompetensi?->kategori_kinerja_id);
                            $weighted = 0; $totalBobot = 0;
                            foreach ($grouped as $items) {
                                $bobot = $items->first()->kompetensi?->kategoriKinerja?->bobot ?? 0;
                                $avg   = $items->avg('nilai');
                                $weighted   += ($avg * $bobot);
                                $totalBobot += $bobot;
                            }
                            if ($totalBobot > 0) $nilaiAkhir = $weighted / $totalBobot;
                        }

                        $rating = '-'; $ratingColor = 'secondary';
                        if ($nilaiAkhir !== null) {
                            if      ($nilaiAkhir >= 90) { $rating = 'A â€” Sangat Baik';   $ratingColor = 'success'; }
                            elseif  ($nilaiAkhir >= 80) { $rating = 'B â€” Baik';           $ratingColor = 'primary'; }
                            elseif  ($nilaiAkhir >= 70) { $rating = 'C â€” Cukup';          $ratingColor = 'warning'; }
                            elseif  ($nilaiAkhir >= 60) { $rating = 'D â€” Kurang';         $ratingColor = 'danger'; }
                            else                        { $rating = 'E â€” Sangat Kurang';  $ratingColor = 'dark'; }
                        }
                    ?>
                    <tr>
                        <td><?php echo e($karyawanList->firstItem() + $i); ?></td>
                        <td>
                            <div class="fw-semibold"><?php echo e($k->nama_karyawan); ?></div>
                            <small class="text-muted"><?php echo e($k->kode_karyawan); ?></small>
                        </td>
                        <td>
                            <?php if($k->pangkalan): ?>
                                <small class="badge bg-light text-dark border"><?php echo e($k->pangkalan->kode_pangkalan); ?></small>
                                <?php echo e($k->pangkalan->nama_pangkalan); ?>

                            <?php else: ?> <span class="text-muted">-</span> <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <div class="progress mb-1" style="height:5px;">
                                <div class="progress-bar <?php echo e($terisi == $totalKompetensi ? 'bg-success' : 'bg-primary'); ?>"
                                     style="width:<?php echo e($progress); ?>%"></div>
                            </div>
                            <span class="<?php echo e($terisi == $totalKompetensi ? 'text-success fw-semibold' : ''); ?>">
                                <?php echo e($terisi); ?>/<?php echo e($totalKompetensi); ?>

                            </span>
                        </td>
                        <td class="text-center fw-bold fs-6">
                            <?php echo e($nilaiAkhir !== null ? number_format($nilaiAkhir, 2) : '-'); ?>

                        </td>
                        <td class="text-center">
                            <?php if($nilaiAkhir !== null): ?>
                                <span class="badge bg-<?php echo e($ratingColor); ?>"><?php echo e($rating); ?></span>
                            <?php else: ?> <span class="text-muted">Belum dinilai</span> <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?php echo e(route('admin.transaksi.create', ['karyawan_id' => $k->id, 'tahun_penilaian_id' => $selectedTahun])); ?>"
                               class="btn btn-warning btn-action" title="Input/Edit Nilai">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php if($terisi > 0): ?>
                            <form method="POST"
                                  action="<?php echo e(route('admin.transaksi.hapus-karyawan', $k)); ?>"
                                  class="d-inline"
                                  onsubmit="return confirm('Hapus semua penilaian <?php echo e(addslashes($k->nama_karyawan)); ?>?')">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <input type="hidden" name="tahun_penilaian_id" value="<?php echo e($selectedTahun); ?>">
                                <button class="btn btn-danger btn-action" title="Hapus Semua">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="7" class="text-center text-muted py-4">
                        Belum ada karyawan untuk tahun ini.
                        <a href="<?php echo e(route('admin.transaksi.create', $selectedTahun ? ['tahun_penilaian_id' => $selectedTahun] : [])); ?>">Input nilai sekarang</a>
                    </td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php if($karyawanList->hasPages()): ?>
    <div class="card-footer"><?php echo e($karyawanList->links()); ?></div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Project\Blanko Penilaian Pengabdian\penilaian-pengabdian\resources\views/admin/transaksi/index.blade.php ENDPATH**/ ?>