﻿
<?php $__env->startSection('title','Laporan'); ?>
<?php $__env->startSection('page-title','Laporan Penilaian Pengabdian'); ?>
<?php $__env->startSection('content'); ?>


<form method="GET" action="<?php echo e(route('admin.laporan.index')); ?>" class="mb-3 d-flex align-items-center gap-2">
    <label class="fw-semibold me-1" style="font-size:.85rem; white-space:nowrap;"><i class="bi bi-funnel me-1"></i>Tahun Ajaran:</label>
    <select name="tahun_penilaian_id" class="form-select form-select-sm" style="max-width:200px;" onchange="this.form.submit()">
        <option value="">-- Semua Tahun --</option>
        <?php $__currentLoopData = $tahunList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($t->id); ?>" <?php echo e($selectedTahun == $t->id ? 'selected' : ''); ?>>
            <?php echo e($t->periode_penilaian); ?> <?php echo e($t->is_active ? '(Aktif)' : ''); ?>

        </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
    <?php if($selectedTahun): ?>
        <a href="<?php echo e(route('admin.laporan.index')); ?>" class="btn btn-sm btn-outline-secondary">Reset</a>
    <?php endif; ?>
</form>


<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body py-3">
                <div class="fs-3 fw-bold text-primary"><?php echo e($karyawanList->count()); ?></div>
                <div class="text-muted" style="font-size:.8rem;">Total Karyawan</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body py-3">
                <div class="fs-3 fw-bold text-success"><?php echo e($totalTransaksi); ?></div>
                <div class="text-muted" style="font-size:.8rem;">Total Data Penilaian</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body py-3">
                <div class="fs-3 fw-bold text-info"><?php echo e($totalKompetensi); ?></div>
                <div class="text-muted" style="font-size:.8rem;">Indikator Kompetensi</div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card text-center">
            <div class="card-body py-3">
                <?php
                    $rated = $karyawanList->filter(fn($k) => $k->transaksi->count() > 0)->count();
                    $pct   = $karyawanList->count() > 0 ? round($rated / $karyawanList->count() * 100) : 0;
                ?>
                <div class="fs-3 fw-bold text-warning"><?php echo e($pct); ?>%</div>
                <div class="text-muted" style="font-size:.8rem;">Sudah Dinilai (<?php echo e($rated); ?>/<?php echo e($karyawanList->count()); ?>)</div>
            </div>
        </div>
    </div>
</div>


<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center py-2">
        <span class="fw-semibold">
            <i class="bi bi-table me-2"></i>Rekapitulasi Nilai Pengabdian
            <?php if($selectedTahunData): ?>
                <span class="text-primary ms-1">â€” <?php echo e($selectedTahunData->periode_penilaian); ?></span>
            <?php endif; ?>
        </span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-bordered table-hover mb-0 align-middle" style="font-size:.82rem;">
                <thead class="table-dark">
                    <tr>
                        <th rowspan="2" class="align-middle text-center" width="36">No</th>
                        <th rowspan="2" class="align-middle">Nama Karyawan</th>
                        <th rowspan="2" class="align-middle">Pangkalan Job</th>
                        <?php $__currentLoopData = $kategoriList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th colspan="<?php echo e($kat->kompetensi->count()); ?>" class="text-center">
                            <?php echo e($kat->kategori); ?>

                            <div class="badge bg-info text-dark fw-normal" style="font-size:.7rem;">Bobot <?php echo e($kat->bobot); ?>%</div>
                        </th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th rowspan="2" class="align-middle text-center">Nilai Akhir</th>
                        <th rowspan="2" class="align-middle text-center">Rating</th>
                    </tr>
                    <tr class="table-secondary">
                        <?php $__currentLoopData = $kategoriList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $kat->kompetensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $komp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="text-center" style="white-space:nowrap; font-size:.75rem; font-weight:600;">
                                <?php echo e($komp->kode_kompetensi); ?><br>
                                <span class="fw-normal text-muted" style="font-size:.7rem;"><?php echo e($komp->kompetensi); ?></span>
                            </th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $karyawanList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $trx = $k->transaksi->keyBy('kompetensi_id');

                        // Weighted score calculation
                        $nilaiAkhir = null;
                        $weighted = 0; $totalBobot = 0;
                        foreach ($kategoriList as $kat) {
                            $bobot = $kat->bobot;
                            $vals = [];
                            foreach ($kat->kompetensi as $komp) {
                                $t = $trx->get($komp->id);
                                if ($t && $t->nilai !== null) $vals[] = (float) $t->nilai;
                            }
                            if (count($vals) > 0) {
                                $avg = array_sum($vals) / count($vals);
                                $weighted   += $avg * $bobot;
                                $totalBobot += $bobot;
                            }
                        }
                        if ($totalBobot > 0) $nilaiAkhir = $weighted / $totalBobot;

                        $rating = '-'; $ratingColor = 'secondary';
                        if ($nilaiAkhir !== null) {
                            if      ($nilaiAkhir >= 90) { $rating = 'A â€” Sangat Baik';   $ratingColor = 'success'; }
                            elseif  ($nilaiAkhir >= 80) { $rating = 'B â€” Baik';           $ratingColor = 'primary'; }
                            elseif  ($nilaiAkhir >= 70) { $rating = 'C â€” Cukup';          $ratingColor = 'warning'; }
                            elseif  ($nilaiAkhir >= 60) { $rating = 'D â€” Kurang';         $ratingColor = 'danger'; }
                            else                        { $rating = 'E â€” Sangat Kurang';  $ratingColor = 'dark'; }
                        }
                    ?>
                    <tr>
                        <td class="text-center"><?php echo e($i + 1); ?></td>
                        <td>
                            <div class="fw-semibold"><?php echo e($k->nama_karyawan); ?></div>
                            <small class="text-muted"><?php echo e($k->kode_karyawan); ?></small>
                        </td>
                        <td style="white-space:nowrap;">
                            <?php echo e($k->pangkalan?->nama_pangkalan ?? '-'); ?>

                        </td>
                        <?php $__currentLoopData = $kategoriList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $kat->kompetensi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $komp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-center">
                                <?php $t = $trx->get($komp->id); ?>
                                <?php if($t && $t->nilai !== null): ?>
                                    <span class="fw-semibold"><?php echo e(number_format($t->nilai, 0)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td class="text-center fw-bold fs-6">
                            <?php echo e($nilaiAkhir !== null ? number_format($nilaiAkhir, 2) : '-'); ?>

                        </td>
                        <td class="text-center">
                            <?php if($nilaiAkhir !== null): ?>
                                <span class="badge bg-<?php echo e($ratingColor); ?>"><?php echo e($rating); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(3 + $kategoriList->sum(fn($k) => $k->kompetensi->count()) + 2); ?>"
                            class="text-center text-muted py-4">
                            Tidak ada data untuk tahun ini.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Project\Blanko Penilaian Pengabdian\penilaian-pengabdian\resources\views/admin/laporan/index.blade.php ENDPATH**/ ?>